DROP PROCEDURE IF EXISTS sp_mostrarProductos;

delimiter $
CREATE DEFINER=`root`@`localhost` PROCEDURE sp_mostrarProductos(IN p_idProducto INT, 
	IN p_idClase INT, IN p_idSubcategoria INT, IN p_tipoOperacion INT)
BEGIN    
	IF p_tipoOperacion = 1 THEN     		
		SELECT 
			P.idProducto,            
			CONCAT(C.abreviatura, P.codigo) AS codigo,
            P.nombre,
            CA.idCategoria,
            CA.nombre as 'categoria',
            S.idSubCategoria,
            S.nombre as 'subcategoria',
			P.idClase,            
			C.nombre as 'clase',
            P.marca,
            P.modelo,
            P.cod_fab,
            (CASE WHEN P.activo = 1 THEN 'SI' 
				WHEN P.activo = 0 THEN 'NO' 
			END) AS activo
		FROM PRODUCTO P
        INNER JOIN CLASE C ON C.idClase = P.idClase and (C.idClase = p_idClase or '0' = p_idClase)
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria and (S.idSubcategoria = p_idSubcategoria or '0' = p_idSubcategoria)
        INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria 
        WHERE P.anulado = 0
		ORDER BY P.nombre;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 	
		SELECT 
			P.idProducto,            
			CONCAT(C.abreviatura, P.codigo) AS codigo,
            P.codigoContable,
            P.nombre,
            CA.idCategoria,
            CA.nombre as 'categoria',
            S.idSubCategoria,
            S.nombre as 'subcategoria',
			P.idClase,            
			C.nombre as 'clase',
            P.marca,
            P.modelo,
            P.cod_fab,
            P.activo
		FROM PRODUCTO P
        INNER JOIN CLASE C ON C.idClase = P.idClase
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
        INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria   
        WHERE P.activo = 1 and P.anulado = 0
		ORDER BY P.idProducto;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 			
		SELECT       
			P.idProducto,            
			CONCAT(C.abreviatura, P.codigo) AS codigo,
            P.nombre,
            CA.idCategoria,
            CA.nombre as 'categoria',
            S.idSubCategoria,
            S.nombre as 'subcategoria',
			P.idClase,            
			C.nombre as 'clase',
            P.codigoContable,
            P.marca,
            IFNULL(P.modelo, '') AS modelo, IFNULL(P.medida, '') AS medida, P.codigoContable, IFNULL(P.cod_fab, '') AS cod_fab, 
            IFNULL(P.talla, '') AS talla, IFNULL(P.color, '') AS color, IFNULL(P.lineaNegocio, '') AS lineaNegocio,
            P.stockMin, P.stockActual, P.unidad_medida, P.tipo_existencia,
            IFNULL(P.valor_unitario, 0) AS valor_unitario, 
            IFNULL(P.igv_unitario, 0) AS igv_unitario, 
            IFNULL(P.precio_unitario, 0) AS precio_unitario,
            P.aplicaVenta,
            P.activo
		FROM PRODUCTO P
        INNER JOIN CLASE C ON C.idClase = P.idClase
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
        INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria
        WHERE P.idProducto = p_idProducto and P.anulado = 0;
	END IF;
    
    IF p_tipoOperacion = 4 THEN 	
		SELECT 
			P.idProducto,            
			CONCAT(C.abreviatura, P.codigo) AS codigo,
            P.nombre,
            CA.idCategoria,
            CA.nombre as 'categoria',
            S.idSubCategoria,
            S.nombre as 'subcategoria',
			P.idClase,            
			C.nombre as 'clase',
            P.marca,
            P.modelo,
            P.cod_fab,
            P.activo
		FROM PRODUCTO P
        INNER JOIN CLASE C ON C.idClase = P.idClase
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria
        INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria       
        WHERE P.idClase = p_idClase and P.activo = 1 and P.anulado = 0
		ORDER BY P.nombre;
	END IF;       
    
    IF p_tipoOperacion = 5 THEN 	
		SELECT CP.idCatalogo, CP.idProveedor, CP.nombre, CP.codigo, P.nombreEmpresa        
        FROM CATALOGO_PROVEEDOR CP
        INNER JOIN PROVEEDOR P ON P.idProveedor = CP.idProveedor
        WHERE idProducto = p_idProducto and P.anulado = 0
        ORDER BY P.nombreEmpresa;
	END IF;
    
    IF p_tipoOperacion = 6 THEN   		
		SELECT 
			P.idProducto,
            CONCAT(C.abreviatura, P.codigo) AS codigo,
            P.codigoContable,
            P.nombre
		FROM PRODUCTO P
        INNER JOIN CLASE C ON C.idClase = P.idClase
        WHERE P.activo = 1 and P.anulado = 0
		ORDER BY P.codigoContable;
	END IF;
    
    IF p_tipoOperacion = 7 THEN     		
		SELECT 
			P.idProducto,            
            CONCAT(C.abreviatura, '-', P.codigo) AS codigo,
            P.nombre,
            CA.idCategoria,
            CA.nombre as 'categoria',
            S.idSubCategoria,
            S.nombre as 'subcategoria',
			P.idClase,            
			C.nombre as 'clase',
            P.marca,
            P.modelo,
            P.medida,
            P.cod_fab,
			P.stockMin, P.stockActual, 
            P.unidad_medida, M.descripcion as unidadMedida, P.tipo_existencia, M2.descripcion as tipoExistencia,
    
            (CASE WHEN P.activo = 1 THEN 'SI' 
				WHEN P.activo = 0 THEN 'NO' 
			END) AS activo,
            CASE 
				WHEN P.stockMin = 0 and P.stockActual < P.stockMin then 'BAJO' 
                WHEN P.stockMin = 0 and P.stockActual >= P.stockMin and P.stockActual <= 5 then 'MEDIO' 
                WHEN P.stockMin = 0 and P.stockActual > 5 then 'ALTO' 
				WHEN P.stockMin > 0 and P.stockActual <= P.stockMin then 'BAJO' 
				WHEN P.stockMin > 0 and P.stockActual > P.stockMin and P.stockActual <= 1.5*P.stockMin THEN 'MEDIO'
				WHEN P.stockMin > 0 and P.stockActual >= 1.5*P.stockMin THEN 'ALTO'                
			END AS 'estado'
		FROM PRODUCTO P
        INNER JOIN CLASE C ON C.idClase = P.idClase and (C.idClase = p_idClase or '0' = p_idClase)
        INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria and (S.idSubcategoria = p_idSubcategoria or '0' = p_idSubcategoria)
        INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria
		INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida and M.dep_id = 3
		INNER JOIN MULTITABLA M2 ON M2.abrev = P.tipo_existencia and M2.dep_id = 14
        WHERE P.anulado = 0
		ORDER BY P.nombre;
    END	IF; 
END
$